#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>

typedef long long ll;

#define MAXN 1000005
#define INF  ((ll)4e18)

ll x[MAXN], h[MAXN];
ll ans[MAXN];
int idx[MAXN];
int st[MAXN];

int cmp(const void *a, const void *b) {
    int i = *(const int*)a;
    int j = *(const int*)b;
    if (x[i] < x[j]) return -1;
    if (x[i] > x[j]) return 1;
    return 0;
}

int main() {
    int n;
    scanf("%d", &n);

    for (int i = 0; i < n; i++) scanf("%lld", &x[i]);
    for (int i = 0; i < n; i++) {
        scanf("%lld", &h[i]);
        ans[i] = INF;
        idx[i] = i;
    }

    qsort(idx, n, sizeof(int), cmp);

    /* ---- nearest higher to the left ---- */
    int top = 0;
    for (int k = 0; k < n; k++) {
        int i = idx[k];
        while (top && h[st[top-1]] < h[i]) top--;
        if (top) {
            int j = st[top-1];
            ll dx = llabs(x[i] - x[j]);
            ll dy = h[j] - h[i];
            ans[i] = dx*dx + dy*dy < ans[i] ? dx*dx + dy*dy : ans[i];
        }
        st[top++] = i;
    }

    /* ---- nearest higher to the right ---- */
    top = 0;
    for (int k = n-1; k >= 0; k--) {
        int i = idx[k];
        while (top && h[st[top-1]] < h[i]) top--;
        if (top) {
            int j = st[top-1];
            ll dx = llabs(x[i] - x[j]);
            ll dy = h[j] - h[i];
            ans[i] = dx*dx + dy*dy < ans[i] ? dx*dx + dy*dy : ans[i];
        }
        st[top++] = i;
    }

    /* ---- ropes (only adjacent after sorting) ---- */
    for (int k = 0; k + 1 < n; k++) {
        int i = idx[k];
        int j = idx[k+1];

        ll dx = x[j] - x[i];
        ll maxh = (h[i] + h[j] + dx) / 2;

        if (maxh >= h[i]) {
            /* horizontal distance to rope */
            ll d = (x[j] - x[i] - (h[j] - h[i])) / 2;
            if (d >= 0) {
                ll sq = d * d;
                if (sq < ans[i]) ans[i] = sq;
            }
        }

        if (maxh >= h[j]) {
            ll d = (x[j] - x[i] - (h[i] - h[j])) / 2;
            if (d >= 0) {
                ll sq = d * d;
                if (sq < ans[j]) ans[j] = sq;
            }
        }
    }

    /* ---- output ---- */
    for (int i = 0; i < n; i++) {
        if (ans[i] == INF) {
            printf("-1\n");
        } else {
            printf("%lld\n", (ll)sqrt((long double)ans[i]));
        }
    }

    return 0;
}